;; My custom domain
;; Simple path-finding with cost

(define (domain custom)
    (:requirements :strips :action-costs)
    (:predicates 
        (truck ?truck)
        (city ?city)
        (truck-at ?truck ?city)
        (connected ?city ?city)
    )
    (:functions
        (distance ?from ?to)
        (total-cost)
    )

(:action drive
    :parameters
    (?truck
     ?from
     ?to)
    :precondition (and 
        (truck ?truck) (city ?from)
        (city ?to) (connected ?from ?to)
        (truck-at ?truck ?from)
      )
    :effect (and 
        (truck-at ?truck ?to) (not (truck-at ?truck ?from))
        (increase (total-cost) (distance ?from ?to))
      )
)

) 
